/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.entity.bee;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.Feeder;
import cy.jdkdigital.productivebees.common.block.entity.AdvancedBeehiveBlockEntityAbstract;
import cy.jdkdigital.productivebees.common.block.entity.FeederBlockEntity;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBee;
import cy.jdkdigital.productivebees.common.entity.bee.hive.RancherBee;
import cy.jdkdigital.productivebees.common.entity.bee.solitary.BumbleBee;
import cy.jdkdigital.productivebees.common.recipe.BlockConversionRecipe;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.util.BeeAttribute;
import cy.jdkdigital.productivebees.util.BeeAttributes;
import cy.jdkdigital.productivebees.util.BeeCreator;
import cy.jdkdigital.productivebees.util.BeeEffect;
import cy.jdkdigital.productivebees.util.BeeHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.items.CapabilityItemHandler;

public class ProductiveBee
extends Bee {
    protected Map<BeeAttribute<?>, Object> beeAttributes = new HashMap();
    protected Predicate<PoiType> beehiveInterests = poiType -> poiType == PoiType.f_27348_;
    private boolean renderStatic = false;
    private int happyCounter = 0;
    protected FollowParentGoal followParentGoal;
    protected BreedGoal breedGoal;
    protected EnterHiveGoal enterHiveGoal;
    private int breedItemCount;

    public ProductiveBee(EntityType<? extends Bee> entityType, Level world) {
        super(entityType, world);
        this.setAttributeValue(BeeAttributes.PRODUCTIVITY, this.f_19853_.f_46441_.nextInt(3));
        this.setAttributeValue(BeeAttributes.TEMPER, 1);
        this.setAttributeValue(BeeAttributes.ENDURANCE, this.f_19853_.f_46441_.nextInt(3));
        this.setAttributeValue(BeeAttributes.BEHAVIOR, 0);
        this.setAttributeValue(BeeAttributes.WEATHER_TOLERANCE, 0);
        this.setAttributeValue(BeeAttributes.TYPE, "hive");
        this.f_21345_.m_25352_(3, (Goal)new ProductiveTemptGoal((PathfinderMob)this, 1.25));
    }

    protected void m_8099_() {
        this.registerBaseGoals();
        this.f_27699_ = new PollinateGoal();
        this.f_21345_.m_25352_(4, (Goal)this.f_27699_);
        this.f_27701_ = new Bee.BeeGoToKnownFlowerGoal((Bee)this);
        this.f_21345_.m_25352_(6, (Goal)this.f_27701_);
        this.f_21345_.m_25352_(7, (Goal)new Bee.BeeGrowCropGoal((Bee)this));
    }

    protected void registerBaseGoals() {
        this.f_21345_.m_25352_(0, (Goal)new BeeAttackGoal((PathfinderMob)this, 1.4, true));
        this.enterHiveGoal = new EnterHiveGoal();
        this.f_21345_.m_25352_(1, (Goal)this.enterHiveGoal);
        this.breedGoal = new BreedGoal((Animal)this, 1.0, ProductiveBee.class);
        this.f_21345_.m_25352_(2, (Goal)this.breedGoal);
        this.followParentGoal = new FollowParentGoal((Animal)this, 1.25);
        this.f_21345_.m_25352_(5, (Goal)this.followParentGoal);
        this.f_21345_.m_25352_(5, (Goal)new UpdateNestGoal());
        this.f_27700_ = new FindNestGoal();
        this.f_21345_.m_25352_(5, (Goal)this.f_27700_);
        if (!((Boolean)ProductiveBeesConfig.BEES.disableWanderGoal.get()).booleanValue()) {
            this.f_21345_.m_25352_(8, (Goal)new BetterBeeWanderGoal());
        }
        this.f_21345_.m_25352_(9, (Goal)new FloatGoal((Mob)this));
        if (!this.getBeeName().equals("kamikaz")) {
            this.f_21346_.m_25352_(1, (Goal)new Bee.BeeHurtByOtherGoal((Bee)this, (Bee)this).m_26044_(new Class[0]));
        }
        this.f_21346_.m_25352_(2, (Goal)new Bee.BeeBecomeAngryTargetGoal((Bee)this));
        this.f_27699_ = new EmptyPollinateGoal();
        this.f_27701_ = new EmptyFindFlowerGoal();
    }

    public void m_8119_() {
        BeeEffect effect;
        super.m_8119_();
        if (!this.f_19853_.f_46443_ && this.f_19797_ % (Integer)ProductiveBeesConfig.BEE_ATTRIBUTES.effectTicks.get() == 0 && (effect = this.getBeeEffect()) != null && effect.getEffects().size() > 0) {
            List<Object> entities = new ArrayList();
            entities = this.getBeeType().equals("") ? this.f_19853_.m_45976_(LivingEntity.class, new AABB(new BlockPos((Vec3i)this.m_142538_())).m_82377_(8.0, 6.0, 8.0)) : this.f_19853_.m_45976_(Player.class, new AABB(new BlockPos((Vec3i)this.m_142538_())).m_82377_(8.0, 6.0, 8.0)).stream().map(player -> player).collect(Collectors.toList());
            if (entities.size() > 0) {
                entities.forEach(playerEntity -> {
                    for (Map.Entry<MobEffect, Integer> entry : effect.getEffects().entrySet()) {
                        MobEffect potionEffect = entry.getKey();
                        Integer duration = entry.getValue();
                        playerEntity.m_7292_(new MobEffectInstance(potionEffect, duration.intValue()));
                    }
                });
            }
        }
        if (!this.f_19853_.f_46443_ && this.m_21523_() && this.f_19797_ % (Integer)ProductiveBeesConfig.BEE_ATTRIBUTES.leashedTicks.get() == 0) {
            boolean isInDayCycleDanger;
            int behavior;
            int tolerance = this.getAttributeValue(BeeAttributes.WEATHER_TOLERANCE);
            if (tolerance < 2 && (double)this.f_19853_.f_46441_.nextFloat() < (Double)ProductiveBeesConfig.BEE_ATTRIBUTES.toleranceChance.get() && tolerance < 1 && (this.f_19853_.m_46758_(this.m_142538_()) || this.f_19853_.m_46470_())) {
                this.beeAttributes.put(BeeAttributes.WEATHER_TOLERANCE, tolerance + 1);
            }
            if ((behavior = this.getAttributeValue(BeeAttributes.BEHAVIOR).intValue()) < 2 && (double)this.f_19853_.f_46441_.nextFloat() < (Double)ProductiveBeesConfig.BEE_ATTRIBUTES.behaviorChance.get()) {
                if (behavior < 1 && this.f_19853_.m_46462_()) {
                    this.beeAttributes.put(BeeAttributes.BEHAVIOR, this.f_19853_.f_46441_.nextFloat() < 0.85f ? 1 : 2);
                } else if (behavior == 1 && !this.f_19853_.m_46462_()) {
                    this.beeAttributes.put(BeeAttributes.BEHAVIOR, this.f_19853_.f_46441_.nextFloat() < 0.9f ? 2 : 0);
                }
            }
            boolean isInDangerFromRain = tolerance < 1 && this.f_19853_.m_46758_(this.m_142538_());
            boolean bl = isInDayCycleDanger = behavior < 1 && this.f_19853_.m_46462_() || behavior == 1 && this.f_19853_.m_46461_();
            if ((isInDangerFromRain || isInDayCycleDanger) && (double)this.f_19853_.f_46441_.nextFloat() < (Double)ProductiveBeesConfig.BEE_ATTRIBUTES.damageChance.get()) {
                this.m_6469_(isInDangerFromRain ? DamageSource.f_19312_ : DamageSource.f_19318_, this.m_21233_() / 3.0f - 1.0f);
            }
        }
        this.updateHappiness();
        if (this.m_20186_() < -65.0) {
            this.m_6088_();
        }
    }

    public void m_6710_(@Nullable LivingEntity livingEntity) {
        ItemStack itemstack;
        boolean isWearingBeeHelmet = false;
        if (livingEntity != null && !(itemstack = livingEntity.m_6844_(EquipmentSlot.HEAD)).m_41619_() && itemstack.m_41720_().equals(ModItems.BEE_NEST_DIAMOND_HELMET.get())) {
            isWearingBeeHelmet = true;
        }
        if (!isWearingBeeHelmet) {
            super.m_6710_(livingEntity);
        }
    }

    private void updateHappiness() {
        if (this.happyCounter > 0) {
            --this.happyCounter;
        }
    }

    @Nonnull
    public EntityDimensions m_6972_(Pose poseIn) {
        return super.m_6972_(poseIn).m_20388_(this.getSizeModifier());
    }

    public float getSizeModifier() {
        return 1.0f;
    }

    @Nonnull
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (player.m_21120_(hand).m_41619_() && !this.f_19853_.f_46443_ && this instanceof BumbleBee) {
            this.happyCounter = 2400;
            this.f_19853_.m_7605_((Entity)this, (byte)18);
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_21660_() {
        return super.m_21660_() && this.getAttributeValue(BeeAttributes.TEMPER) > 0;
    }

    public boolean m_27896_(@Nullable BlockPos pos) {
        if (pos == null || !this.f_19853_.m_46749_(pos)) {
            return false;
        }
        BlockState flowerBlock = this.f_19853_.m_8055_(pos);
        return this.isFlowerBlock(flowerBlock) || flowerBlock.m_60734_() instanceof Feeder && ProductiveBee.isValidFeeder(this.f_19853_.m_7702_(pos), this::isFlowerBlock);
    }

    public List<ItemStack> getBreedingItems() {
        int count = this.getBreedingItemCount();
        List<ItemStack> list = Arrays.stream(this.getBreedingIngredient().m_43908_()).toList();
        list.forEach(e -> e.m_41764_(count));
        return list;
    }

    public Ingredient getBreedingIngredient() {
        return Ingredient.m_204132_((TagKey)ItemTags.f_13149_);
    }

    public Integer getBreedingItemCount() {
        return 1;
    }

    public boolean m_6898_(ItemStack stack) {
        return this.getBreedingIngredient().test(stack);
    }

    public Predicate<PoiType> getBeehiveInterests() {
        return this.beehiveInterests;
    }

    public boolean doesHiveAcceptBee(BlockPos pos) {
        BlockEntity blockEntity = this.f_19853_.m_7702_(pos);
        if (blockEntity instanceof AdvancedBeehiveBlockEntityAbstract) {
            return ((AdvancedBeehiveBlockEntityAbstract)blockEntity).acceptsBee(this);
        }
        return true;
    }

    public static boolean isValidFeeder(BlockEntity tile, Predicate<BlockState> validator) {
        AtomicBoolean hasValidBlock = new AtomicBoolean(false);
        if (tile instanceof FeederBlockEntity) {
            tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
                for (int slot = 0; slot < handler.getSlots(); ++slot) {
                    Item slotItem = handler.getStackInSlot(slot).m_41720_();
                    if (!(slotItem instanceof BlockItem) || !validator.test(((BlockItem)slotItem).m_40614_().m_49966_())) continue;
                    hasValidBlock.set(true);
                }
            });
        }
        return hasValidBlock.get();
    }

    protected void m_142075_(Player player, InteractionHand hand, ItemStack stack) {
        super.m_142075_(player, hand, stack);
        this.f_19853_.m_7605_((Entity)this, (byte)13);
        ++this.breedItemCount;
    }

    public void m_27595_(@Nullable Player player) {
        if (this.breedItemCount >= this.getBreedingItemCount()) {
            super.m_27595_(player);
            this.breedItemCount = 0;
        }
    }

    public boolean m_27866_() {
        if (this.f_27711_ <= 0 && !this.f_27699_.m_28086_() && !this.m_27857_() && this.m_5448_() == null) {
            ServerLevel sLevel;
            Level level;
            boolean shouldReturnToHive = this.m_27865_() || this.m_27856_() || (level = this.f_19853_) instanceof ServerLevel && (sLevel = (ServerLevel)level).m_143333_() && (this.f_19853_.m_46462_() && !this.canOperateDuringNight() || this.f_19853_.m_46758_(this.m_142538_()) && !this.canOperateDuringRain() || this.f_19853_.m_46470_() && !this.canOperateDuringThunder());
            return shouldReturnToHive && !this.m_27868_();
        }
        return false;
    }

    public void m_27925_(boolean hasStung) {
        if (hasStung && this.getAttributeValue(BeeAttributes.ENDURANCE) == 2) {
            hasStung = this.f_19853_.f_46441_.nextBoolean();
        }
        if (hasStung && this.getAttributeValue(BeeAttributes.ENDURANCE) == 3) {
            hasStung = (double)this.f_19853_.f_46441_.nextFloat() < 0.2;
        }
        super.m_27925_(hasStung);
        if (hasStung && this.getBeeName().equals("kamikaz")) {
            this.m_6469_(DamageSource.f_19318_, this.m_21223_());
        }
    }

    public String getBeeType() {
        return this.m_20078_();
    }

    public String getBeeName() {
        return ProductiveBee.getBeeName(this.getBeeType());
    }

    public static String getBeeName(String beeType) {
        String[] types = beeType.split("[:]");
        String type = types[0];
        if (types.length > 1) {
            type = types[1];
        }
        return type.replace("_bee", "");
    }

    public String getRenderer() {
        return "default";
    }

    public <T> T getAttributeValue(BeeAttribute<T> parameter) {
        return (T)this.beeAttributes.get(parameter);
    }

    public void setAttributeValue(BeeAttribute<?> parameter, Integer value) {
        AttributeInstance healthMod;
        if (((Object)parameter).equals(BeeAttributes.ENDURANCE) && (healthMod = this.m_21051_(Attributes.f_22276_)) != null && value != 1) {
            healthMod.m_22120_(BeeAttributes.HEALTH_MOD_ID_WEAK);
            healthMod.m_22120_(BeeAttributes.HEALTH_MOD_ID_MEDIUM);
            healthMod.m_22120_(BeeAttributes.HEALTH_MOD_ID_STRONG);
            healthMod.m_22125_(BeeAttributes.HEALTH_MODS.get(value));
        }
        this.beeAttributes.put(parameter, value);
    }

    public void setAttributeValue(BeeAttribute<?> parameter, Object value) {
        this.beeAttributes.put(parameter, value);
    }

    public Map<BeeAttribute<?>, Object> getBeeAttributes() {
        return this.beeAttributes;
    }

    public boolean canOperateDuringNight() {
        return this.getAttributeValue(BeeAttributes.BEHAVIOR) > 0;
    }

    boolean canOperateDuringRain() {
        return this.getAttributeValue(BeeAttributes.WEATHER_TOLERANCE) > 0;
    }

    boolean canOperateDuringThunder() {
        return this.getAttributeValue(BeeAttributes.WEATHER_TOLERANCE) == 2;
    }

    public int getTimeInHive(boolean hasNectar) {
        return hasNectar ? 2400 : 600;
    }

    public void setRenderStatic() {
        this.renderStatic = true;
    }

    public boolean getRenderStatic() {
        return this.renderStatic;
    }

    public boolean m_6673_(DamageSource source) {
        return source.equals(DamageSource.f_19310_) || source.equals(DamageSource.f_19325_) || source.equals(DamageSource.f_19320_) && this.getBeeType().contains("dye_bee") || super.m_6673_(source);
    }

    @Nonnull
    protected PathNavigation m_6037_(@Nonnull Level worldIn) {
        PathNavigation navigator = super.m_6037_(worldIn);
        if (navigator instanceof FlyingPathNavigation) {
            navigator.m_7008_(false);
            ((FlyingPathNavigation)navigator).m_26443_(false);
        }
        return navigator;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("bee_productivity", this.getAttributeValue(BeeAttributes.PRODUCTIVITY).intValue());
        tag.m_128405_("bee_endurance", this.getAttributeValue(BeeAttributes.ENDURANCE).intValue());
        tag.m_128405_("bee_temper", this.getAttributeValue(BeeAttributes.TEMPER).intValue());
        tag.m_128405_("bee_behavior", this.getAttributeValue(BeeAttributes.BEHAVIOR).intValue());
        tag.m_128405_("bee_weather_tolerance", this.getAttributeValue(BeeAttributes.WEATHER_TOLERANCE).intValue());
        tag.m_128359_("bee_type", this.getAttributeValue(BeeAttributes.TYPE));
        tag.m_128350_("MaxHealth", this.m_21233_());
        tag.m_128379_("HasConverted", this.hasConverted());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("bee_productivity")) {
            this.beeAttributes.clear();
            this.setAttributeValue(BeeAttributes.PRODUCTIVITY, tag.m_128451_("bee_productivity"));
            this.setAttributeValue(BeeAttributes.ENDURANCE, tag.m_128441_("bee_endurance") ? tag.m_128451_("bee_endurance") : 1);
            this.setAttributeValue(BeeAttributes.TEMPER, tag.m_128451_("bee_temper"));
            this.setAttributeValue(BeeAttributes.BEHAVIOR, tag.m_128451_("bee_behavior"));
            this.setAttributeValue(BeeAttributes.WEATHER_TOLERANCE, tag.m_128451_("bee_weather_tolerance"));
            this.setAttributeValue(BeeAttributes.TYPE, tag.m_128461_("bee_type"));
        }
        this.setHasConverted(tag.m_128441_("HasConverted") && tag.m_128471_("HasConverted"));
    }

    public ItemStack getPickedResult(HitResult target) {
        return BeeCreator.getSpawnEgg(this.getBeeType());
    }

    protected void m_142669_() {
        super.m_142669_();
        if (!this.m_6162_()) {
            BlockPos pos = this.m_142538_();
            if (this.f_19853_.m_46859_(pos)) {
                this.m_6034_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            } else if (this.f_19853_.m_46859_(pos.m_7495_())) {
                pos = pos.m_7495_();
                this.m_6034_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            }
        }
    }

    public Bee m_142606_(@Nonnull ServerLevel world, AgeableMob targetEntity) {
        Entity newBee = BeeHelper.getBreedingResult(this, targetEntity, world);
        if (!(newBee instanceof Bee)) {
            return (Bee)EntityType.f_20550_.m_20615_((Level)world);
        }
        if (newBee instanceof ProductiveBee) {
            BeeHelper.setOffspringAttributes((ProductiveBee)newBee, this, targetEntity);
        }
        return (Bee)newBee;
    }

    public boolean m_7848_(@Nonnull Animal otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!(otherAnimal instanceof Bee)) {
            return false;
        }
        return this.m_27593_() && otherAnimal.m_27593_() && (this.f_19853_ instanceof ServerLevel && BeeHelper.getRandomBreedingRecipe(this, (AgeableMob)otherAnimal, (ServerLevel)this.f_19853_) != null || this.canSelfBreed() || !(otherAnimal instanceof ProductiveBee));
    }

    public boolean canSelfBreed() {
        return true;
    }

    public void postPollinate() {
        BlockState flowerBlockState;
        BlockConversionRecipe recipe;
        if (this.m_27856_() && this.f_27697_ != null && (recipe = BeeHelper.getBlockConversionRecipe(this, flowerBlockState = this.f_19853_.m_8055_(this.f_27697_))) != null) {
            if (ProductiveBees.rand.nextInt(100) <= recipe.chance) {
                this.f_19853_.m_7731_(this.f_27697_, recipe.stateTo, 3);
                this.f_19853_.m_46796_(2005, this.f_27697_, 0);
            }
            this.setHasConverted(true);
        }
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return this.m_6162_() ? sizeIn.f_20378_ * 0.25f : sizeIn.f_20378_ * 0.5f;
    }

    public int getColor(int tintIndex) {
        return -1;
    }

    public boolean isFlowerBlock(BlockState flowerBlock) {
        return flowerBlock.m_204336_(BlockTags.f_13041_) || BeeHelper.hasBlockConversionRecipe(this, flowerBlock);
    }

    public TagKey<Block> getNestingTag() {
        return BlockTags.f_13072_;
    }

    public BeeEffect getBeeEffect() {
        return null;
    }

    public boolean hasConverted() {
        return this.m_27921_(16);
    }

    public void setHasConverted(boolean hasConverted) {
        this.m_27832_(16, hasConverted);
    }

    public class ProductiveTemptGoal
    extends TemptGoal {
        public ProductiveTemptGoal(PathfinderMob entity, double speed) {
            super(entity, speed, Ingredient.f_43901_, false);
            List<ItemStack> listOfStuff = Arrays.asList(Ingredient.m_204132_((TagKey)ItemTags.f_13149_).m_43908_());
            this.f_25935_ = Ingredient.m_43921_(listOfStuff.stream());
        }
    }

    public class PollinateGoal
    extends Bee.BeePollinateGoal {
        public Predicate<BlockPos> flowerPredicate;

        public PollinateGoal() {
            super((Bee)ProductiveBee.this);
            this.flowerPredicate = blockPos -> {
                BlockState blockState = ProductiveBee.this.f_19853_.m_8055_(blockPos);
                boolean isInterested = false;
                try {
                    if (blockState.m_60734_() instanceof Feeder) {
                        isInterested = ProductiveBee.isValidFeeder(ProductiveBee.this.f_19853_.m_7702_(blockPos), ProductiveBee.this::isFlowerBlock);
                    } else {
                        isInterested = ProductiveBee.this.isFlowerBlock(blockState);
                        if (isInterested && blockState.m_204336_(BlockTags.f_13040_) && blockState.m_60734_() == Blocks.f_50355_) {
                            isInterested = blockState.m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.UPPER;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return isInterested;
            };
        }

        public boolean m_7989_() {
            if (ProductiveBee.this.f_27714_ > 0) {
                return false;
            }
            if (ProductiveBee.this.m_27856_()) {
                return false;
            }
            if (ProductiveBee.this.f_19853_.m_46758_(ProductiveBee.this.m_142538_()) && !ProductiveBee.this.canOperateDuringRain()) {
                return false;
            }
            if (ProductiveBee.this.f_19853_.m_46470_() && !ProductiveBee.this.canOperateDuringThunder()) {
                return false;
            }
            Optional<BlockPos> optional = this.m_28090_();
            if (optional.isPresent()) {
                ProductiveBee.this.f_27697_ = optional.get();
                ProductiveBee.this.f_21344_.m_26519_((double)ProductiveBee.this.f_27697_.m_123341_() + 0.5, (double)ProductiveBee.this.f_27697_.m_123342_() + 0.5, (double)ProductiveBee.this.f_27697_.m_123343_() + 0.5, (double)1.2f);
                return true;
            }
            ProductiveBee.this.f_27714_ = 70 + ProductiveBee.this.f_19853_.f_46441_.nextInt(50);
            return false;
        }

        public boolean m_8011_() {
            if (!this.m_28086_()) {
                return false;
            }
            if (!ProductiveBee.this.m_27852_()) {
                return false;
            }
            if (ProductiveBee.this.f_19853_.m_46758_(ProductiveBee.this.m_142538_()) && !ProductiveBee.this.canOperateDuringRain()) {
                return false;
            }
            if (ProductiveBee.this.f_19853_.m_46470_() && !ProductiveBee.this.canOperateDuringThunder()) {
                return false;
            }
            if (this.m_28085_()) {
                return ProductiveBee.this.f_19796_.nextFloat() < 0.2f;
            }
            if (ProductiveBee.this.f_19797_ % 20 == 0 && !ProductiveBee.this.m_27896_(ProductiveBee.this.f_27697_)) {
                ProductiveBee.this.f_27697_ = null;
                return false;
            }
            return true;
        }

        public void m_8041_() {
            super.m_8041_();
            ProductiveBee.this.postPollinate();
        }

        @Nonnull
        public Optional<BlockPos> m_28090_() {
            CompoundTag nbt;
            if (ProductiveBee.this instanceof RancherBee) {
                return this.findEntities(RancherBee.predicate, 5.0);
            }
            if (ProductiveBee.this instanceof ConfigurableBee && ((ConfigurableBee)ProductiveBee.this).getFlowerType().equals("entity_types") && (nbt = ((ConfigurableBee)ProductiveBee.this).getNBTData()) != null && nbt.m_128441_("flowerTag")) {
                TagKey flowerTag = TagKey.m_203882_((ResourceKey)Registry.f_122903_, (ResourceLocation)new ResourceLocation(nbt.m_128461_("flowerTag")));
                return this.findEntities(entity -> entity.m_6095_().m_204039_(flowerTag), 5.0);
            }
            return this.findNearestBlock(this.flowerPredicate, 5.0);
        }

        private Optional<BlockPos> findNearestBlock(Predicate<BlockPos> predicate, double distance) {
            BlockPos blockpos = ProductiveBee.this.m_142538_();
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            int i = 0;
            while ((double)i <= distance) {
                int j = 0;
                while ((double)j < distance) {
                    int k = 0;
                    while (k <= j) {
                        int l;
                        int n = l = k < j && k > -j ? j : 0;
                        while (l <= j) {
                            blockpos$mutableblockpos.m_122154_((Vec3i)blockpos, k, i - 1, l);
                            if (blockpos.m_123314_((Vec3i)blockpos$mutableblockpos, distance) && predicate.test((BlockPos)blockpos$mutableblockpos)) {
                                return Optional.of(blockpos$mutableblockpos);
                            }
                            l = l > 0 ? -l : 1 - l;
                        }
                        k = k > 0 ? -k : 1 - k;
                    }
                    ++j;
                }
                i = i > 0 ? -i : 1 - i;
            }
            return Optional.empty();
        }

        private Optional<BlockPos> findEntities(Predicate<Entity> predicate, double distance) {
            BlockPos blockpos = ProductiveBee.this.m_142538_();
            BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
            List entities = ProductiveBee.this.f_19853_.m_6249_((Entity)ProductiveBee.this, new AABB(blockpos).m_82377_(distance, distance, distance), predicate);
            if (entities.size() > 0) {
                PathfinderMob entity = (PathfinderMob)entities.get(0);
                entity.m_21573_().m_26517_(0.0);
                blockpos$mutable.m_122169_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
                return Optional.of(blockpos$mutable);
            }
            return Optional.empty();
        }
    }

    public class BeeAttackGoal
    extends MeleeAttackGoal {
        BeeAttackGoal(PathfinderMob mob, double speedModifier, boolean followingTargetEvenIfNotSeen) {
            super(mob, speedModifier, followingTargetEvenIfNotSeen);
        }

        public boolean m_8036_() {
            return super.m_8036_() && ProductiveBee.this.m_21660_() && !ProductiveBee.this.m_27857_();
        }

        public boolean m_8045_() {
            return super.m_8045_() && ProductiveBee.this.m_21660_() && !ProductiveBee.this.m_27857_();
        }
    }

    public class EnterHiveGoal
    extends Bee.BeeEnterHiveGoal {
        public EnterHiveGoal() {
            super((Bee)ProductiveBee.this);
        }

        public boolean m_7989_() {
            BlockEntity blockEntity;
            if (ProductiveBee.this.f_27698_ != null && ProductiveBee.this.m_27866_() && ProductiveBee.this.f_27698_.m_203195_((Position)ProductiveBee.this.m_20182_(), 2.0) && (blockEntity = ProductiveBee.this.f_19853_.m_7702_(ProductiveBee.this.f_27698_)) instanceof BeehiveBlockEntity) {
                BeehiveBlockEntity beehiveblockentity = (BeehiveBlockEntity)blockEntity;
                if (!beehiveblockentity.m_58775_()) {
                    return true;
                }
                ProductiveBee.this.f_27698_ = null;
            }
            return false;
        }
    }

    public class UpdateNestGoal
    extends Bee.BeeLocateHiveGoal {
        public UpdateNestGoal() {
            super((Bee)ProductiveBee.this);
        }

        public void m_8056_() {
            ProductiveBee.this.f_27713_ = 200;
            List<BlockPos> nearbyNests = this.getNearbyFreeNests();
            if (!nearbyNests.isEmpty()) {
                BlockPos blockPos;
                Iterator<BlockPos> iterator = nearbyNests.iterator();
                do {
                    if (iterator.hasNext()) continue;
                    ProductiveBee.this.f_27700_.m_28006_();
                    ProductiveBee.this.f_27698_ = nearbyNests.get(0);
                    return;
                } while (ProductiveBee.this.f_27700_.m_27993_(blockPos = iterator.next()));
                ProductiveBee.this.f_27698_ = blockPos;
            }
        }

        private List<BlockPos> getNearbyFreeNests() {
            BlockPos pos = ProductiveBee.this.m_142538_();
            PoiManager poiManager = ((ServerLevel)ProductiveBee.this.f_19853_).m_8904_();
            Stream stream = poiManager.m_27181_(ProductiveBee.this.beehiveInterests, pos, 30, PoiManager.Occupancy.ANY);
            return stream.map(PoiRecord::m_27257_).filter(arg_0 -> ((ProductiveBee)ProductiveBee.this).m_27884_(arg_0)).filter(ProductiveBee.this::doesHiveAcceptBee).sorted(Comparator.comparingDouble(vec -> vec.m_123331_((Vec3i)pos))).collect(Collectors.toList());
        }
    }

    public class FindNestGoal
    extends Bee.BeeGoToHiveGoal {
        public FindNestGoal() {
            super((Bee)ProductiveBee.this);
        }

        public boolean m_7989_() {
            if (!ProductiveBee.this.m_27854_()) {
                return false;
            }
            HolderSet.Named nestTag = Registry.f_122824_.m_203561_(ProductiveBee.this.getNestingTag());
            try {
                if (nestTag.m_203632_() == 0) {
                    return false;
                }
            }
            catch (Exception e) {
                String bee = ProductiveBee.this.m_20078_();
                if (ProductiveBee.this instanceof ConfigurableBee) {
                    bee = ProductiveBee.this.getBeeType();
                }
                ProductiveBees.LOGGER.debug("Nesting tag for " + bee + " not found. Looking for " + nestTag);
            }
            return !ProductiveBee.this.m_21536_() && ProductiveBee.this.m_27866_() && !this.isCloseEnough(ProductiveBee.this.f_27698_) && ProductiveBee.this.f_19853_.m_8055_(ProductiveBee.this.f_27698_).m_204341_((HolderSet)nestTag);
        }

        private boolean isCloseEnough(BlockPos pos) {
            if (ProductiveBee.this.m_27816_(pos, 2)) {
                return true;
            }
            Path path = ProductiveBee.this.f_21344_.m_26570_();
            return path != null && path.m_77406_().equals((Object)pos) && path.m_77403_() && path.m_77392_();
        }

        protected void m_27998_(BlockPos pos) {
            BlockEntity tileEntity = ProductiveBee.this.f_19853_.m_7702_(pos);
            TagKey<Block> nestTag = ProductiveBee.this.getNestingTag();
            if (tileEntity != null && tileEntity.m_58900_().m_204336_(nestTag)) {
                this.f_27981_.add(pos);
                while (this.f_27981_.size() > 3) {
                    this.f_27981_.remove(0);
                }
            }
        }
    }

    public class BetterBeeWanderGoal
    extends Bee.BeeWanderGoal {
        public BetterBeeWanderGoal() {
            super((Bee)ProductiveBee.this);
        }

        public boolean m_8036_() {
            return super.m_8036_() || ProductiveBee.this.f_27698_ != null && !ProductiveBee.this.m_27816_(ProductiveBee.this.f_27698_, 22);
        }
    }

    public class EmptyPollinateGoal
    extends PollinateGoal {
        @Override
        public boolean m_7989_() {
            return false;
        }
    }

    public class EmptyFindFlowerGoal
    extends Bee.BeeGoToKnownFlowerGoal {
        public EmptyFindFlowerGoal() {
            super((Bee)ProductiveBee.this);
        }

        public boolean m_7989_() {
            return false;
        }
    }
}

